#include <stdio.h>
#include <thread>
double thlist[10] = { 1.0,0.5,0.2,0.1,0.05,0.02,0.01,0.005,0.002,0.001};
double thlist_mv[10] = {10,1,0,-0.3,-0.6,-0.9,-1.2,-1.5,-1.8,-2.1};
double thlist_2s[10] = { 0, 1,3,10,30,100,300,1000, 3000,10000 };
double thlist_e2e[10] = { 0, 1,3,10,30,100,300,1000, 3000,10000 };
double sum[10][4], sum_mv[10][4], sum_2s[10][4], sum_e2e[10][4], sumsq[10][4], sum_mvsq[10][4], sum_2ssq[10][4], sum_e2esq[10][4];
FILE* out;
void run(int seed, int i)
{
	char fname[200];
	sprintf_s(fname, "C:\\Users\\main_dir_name\\Documents\\or_run\\x64\\Debug\\result_or_%d_%lf.txt", seed, thlist[i]);
	FILE* in;
	fopen_s(&in, fname, "r");
	double loss, best_loss, ulti_best_loss;
	int cnt_vio;
	fscanf_s(in, "%lf\t%d\t%lf\t%lf", &loss, &cnt_vio, &best_loss, &ulti_best_loss);
	fprintf(out, "%d\t%lf\t%lf\t%d\t%lf\t%lf\n", seed, thlist[i], loss, cnt_vio, best_loss, ulti_best_loss);
	sum[i][0] += loss;
	sum[i][1] += cnt_vio*1.0;
	sum[i][2] += best_loss;
	sum[i][3] += ulti_best_loss;
	sumsq[i][1] += loss * loss *1.0;
	sumsq[i][2] += cnt_vio * cnt_vio * 1.0;
	fclose(in);
}
void run_mv(int seed, int i)
{
	char fname[200];
	sprintf_s(fname, "C:\\Users\\main_dir_name\\Documents\\or_run\\x64\\Debug\\result_or_mv_%d_%lf.txt", seed, thlist_mv[i]);
	FILE* in;
	fopen_s(&in, fname, "r");
	double loss, best_loss, ulti_best_loss;
	int cnt_vio;
	fscanf_s(in, "%lf\t%d\t%lf\t%lf", &loss, &cnt_vio, &best_loss, &ulti_best_loss);
	fprintf(out, "%d\t%lf\t%lf\t%d\t%lf\t%lf\n", seed, thlist_mv[i], loss, cnt_vio, best_loss, ulti_best_loss);
	sum_mv[i][0] += loss;
	sum_mv[i][1] += cnt_vio * 1.0;
	sum_mv[i][2] += best_loss;
	sum_mv[i][3] += ulti_best_loss;
	sum_mvsq[i][1] += loss * loss * 1.0;
	sum_mvsq[i][2] += cnt_vio * cnt_vio * 1.0;
	fclose(in);
}
void run_2s(int seed, int i)
{
	char fname[200];
	sprintf_s(fname, "C:\\Users\\main_dir_name\\Documents\\or_run\\x64\\Debug\\result_or_2s_%d_%lf.txt", seed, thlist_2s[i]);
	FILE* in;
	fopen_s(&in, fname, "r");
	double loss, best_loss, ulti_best_loss;
	int cnt_vio;
	fscanf_s(in, "%lf\t%d\t%lf\t%lf", &loss, &cnt_vio, &best_loss, &ulti_best_loss);
	fprintf(out, "%d\t%lf\t%lf\t%d\t%lf\t%lf\n", seed, thlist_2s[i], loss, cnt_vio, best_loss, ulti_best_loss);
	sum_2s[i][0] += loss;
	sum_2s[i][1] += cnt_vio * 1.0;
	sum_2s[i][2] += best_loss;
	sum_2s[i][3] += ulti_best_loss;
	sum_2ssq[i][1] += loss * loss * 1.0;
	sum_2ssq[i][2] += cnt_vio * cnt_vio * 1.0;
	fclose(in);
}
void run_e2e(int seed, int i)
{
	char fname[200];
	sprintf_s(fname, "C:\\Users\\main_dir_name\\Documents\\or_run\\x64\\Debug\\result_or_e2e_%d_%lf.txt", seed, thlist_e2e[i]);
	FILE* in;
	fopen_s(&in, fname, "r");
	double loss, best_loss, ulti_best_loss;
	int cnt_vio;
	fscanf_s(in, "%lf\t%d\t%lf\t%lf", &loss, &cnt_vio, &best_loss, &ulti_best_loss);
	fprintf(out, "%d\t%lf\t%lf\t%d\t%lf\t%lf\n", seed, thlist_e2e[i], loss, cnt_vio, best_loss, ulti_best_loss);
	sum_e2e[i][0] += loss;
	sum_e2e[i][1] += cnt_vio * 1.0;
	sum_e2e[i][2] += best_loss;
	sum_e2e[i][3] += ulti_best_loss;
	sum_e2esq[i][1] += loss * loss * 1.0;
	sum_e2esq[i][2] += cnt_vio * cnt_vio * 1.0;
	fclose(in);
}
int main(void)
{
	int num = 100;
	fopen_s(&out, "results.txt", "w");
	for (int seed = 0;seed < num;seed++)
	{
		for (int i = 0;i < 10;i++)
			run(seed, i);
		for (int i = 0;i < 10;i++)
			run_mv(seed, i);
		for (int i = 0;i < 10;i++)
			run_2s(seed, i);
		for (int i = 0;i < 10;i++)
			run_e2e(seed, i);
	}
	FILE* avg;
	fopen_s(&avg, "average.txt", "w");
	for (int i = 0;i < 10;i++)
		fprintf(avg, "%lf\t%lf\t%lf\t%lf\t%lf\t%lf\t%lf\n", thlist[i], sum[i][0]/num, sum[i][1] / num, sum[i][2] / num, sum[i][3] / num, sqrt(sumsq[i][1]/num/(num-1) - (sum[i][0] / num) * (sum[i][0] / num) / (num - 1)), sqrt(sumsq[i][2] / num / (num - 1) - (sum[i][1] / num) * (sum[i][1] / num) / (num - 1)));
	for (int i = 0;i < 10;i++)
		fprintf(avg, "%lf\t%lf\t%lf\t%lf\t%lf\t%lf\t%lf\n", thlist_mv[i], sum_mv[i][0] / num, sum_mv[i][1] / num, sum_mv[i][2] / num, sum_mv[i][3] / num, sqrt(sum_mvsq[i][1] / num / (num - 1) - (sum_mv[i][0] / num) * (sum_mv[i][0] / num) / (num - 1)), sqrt(sum_mvsq[i][2] / num / (num - 1) - (sum_mv[i][1] / num) * (sum_mv[i][1] / num) / (num - 1)));
	for (int i = 0;i < 10;i++)
		fprintf(avg, "%lf\t%lf\t%lf\t%lf\t%lf\t%lf\t%lf\n", thlist_2s[i], sum_2s[i][0] / num, sum_2s[i][1] / num, sum_2s[i][2] / num, sum_2s[i][3] / num, sqrt(sum_2ssq[i][1] / num / (num - 1) - (sum_2s[i][0] / num) * (sum_2s[i][0] / num) / (num - 1)), sqrt(sum_2ssq[i][2] / num / (num - 1) - (sum_2s[i][1] / num) * (sum_2s[i][1] / num) / (num - 1)));
	for (int i = 0;i < 10;i++)
		fprintf(avg, "%lf\t%lf\t%lf\t%lf\t%lf\t%lf\t%lf\n", thlist_e2e[i], sum_e2e[i][0] / num, sum_e2e[i][1] / num, sum_e2e[i][2] / num, sum_e2e[i][3] / num, sqrt(sum_e2esq[i][1] / num / (num - 1) - (sum_e2e[i][0] / num) * (sum_e2e[i][0] / num) / (num - 1)), sqrt(sum_e2esq[i][2] / num / (num - 1) - (sum_e2e[i][1] / num) * (sum_e2e[i][1] / num) / (num - 1)));
}